#!/bin/bash
################ PBX install - Stage 1: -------------
###### Setup OS: ------------------------------------
INSTSCRIPTVERSION='1.1.1'
PBXVERSION='1.0.8'
INSTALLDATE="$(date +%Y%m%d%H%M)"
SRCSERVER="repo.smpltechno.com:8888"
DOWNLOADLISTURL="http://$SRCSERVER/pbx-load/download-list"
LOCALINSTALL=""
if [ "$1" = "local" ]; then
LOCALINSTALL="y"
DOWNLOADLISTURL=""
SRCSERVER=""
fi
#echo "10.1.5.20		repo.smpltechno.com" >> /etc/hosts
#Check architecture:
ARCH=`uname -i`
#Check for ISO install:
if [ "`grep -o 'KS' /etc/pbx/install-info`" = 'KS' ]; then
	INSTALLTYPE="ISO"
else
	INSTALLTYPE="Script"
fi

#Check for virtualization:
if [ "`lspci |grep -o 'VMware SVGA'`" = 'VMware SVGA' ]; then
	touch /tmp/vmware
	PBXHWTYPE="VMWare"
elif [ "`uname -r 2>/dev/null |grep -o pve`" = 'pve' ]; then
	PBXHWTYPE="OpenVZ"
elif [ "`uname -r 2>/dev/null |grep -o xen`" = 'xen' ]; then
	PBXHWTYPE="Xen or EC2"
elif [ "`lspci |grep -o 'VirtualBox Gra'`" = 'VirtualBox Gra' ]; then
	PBXHWTYPE="VirtualBox"
elif [ "`uname -r 2>/dev/null |grep -o amzn1.x86_64`" = 'amzn1.x86_64' ]; then
	PBXHWTYPE="EC2AMI"
else
	PBXHWTYPE="x86 PC"
fi
export PBXHWTYPE

echo "PBX Install log" > /root/pbx-install.log
date >> /root/pbx-install.log
echo "Install type = $INSTALLTYPE" >> /root/pbx-install.log
echo "Hardware type = $PBXHWTYPE" >> /root/pbx-install.log

echo "SELINUX=disabled" > /etc/selinux/config

###### Download files and dependancies: ------------------
echo "Installing OS packages." >> /root/pbx-install.log
cd /usr/src

###### install yum deps:
#wget --read-timeout=70 -q -O - http://$SRCSERVER/pbx-load/install-freepbx-repo.sh | sh
#wget --read-timeout=70 -q -O - http://$SRCSERVER/pbx-load/install-atomic-repo.sh | sh
#rpm --import http://dev.centos.org/centos/RPM-GPG-KEY-CentOS-testing

yum install -y gcc gcc-c++ lynx bison mysql-devel mysql-server php php-mysql php-pear php-mbstring tftp-server httpd make ncurses-devel libtermcap-devel sendmail sendmail-cf caching-nameserver sox newt-devel libxml2-devel libtiff-devel audiofile-devel gtk2-devel subversion kernel-devel git subversion kernel-devel php-process crontabs cronie cronie-anacron

## johns list:
yum install -y kernel-devel-$(uname -r) subversion gpg openssl-devel speex speex-devel curl-devel doxygen nmap mod_ssl php-gd screen tar dos2unix unzip wget nano ntp bzip2 nmap avahi

echo "Downloading/extracting payload file" >> /root/pbx-install.log
mkdir /var/pbx-load
wget --read-timeout=70 "$SRCSERVER/pbx-load/pbx-load-file.tgz" -O /var/pbx-load/pbx-load-file.tgz
if [ "$LOCALINSTALL" = "y" ]; then
mv ~/pbx-load-file.tgz /var/pbx-load/
fi
cd /
## We will run that extract later for file consistency, running now just to get access to some files
tar xzvf /var/pbx-load/pbx-load-file.tgz >> /root/pbx-install.log

#Add other items for scripted installs:
if [ $INSTALLTYPE = Script ]; then 
echo "whatever this doesnt matter right now"
#yum install -y wget nano ntp bzip2 
fi

echo "Fix OS settings and NTP" >> /root/pbx-install.log

ln -sf /usr/share/zoneinfo/PST8PDT /etc/localtime
cat > /etc/cron.d/ntp-sync <<EOF
0 1 * * * /usr/sbin/ntpdate -s -b -p 8 -u 1.us.pool.ntp.org
EOF
chmod +x /etc/cron.d/ntp-sync
/usr/sbin/ntpdate -s -b -p 8 -u 1.us.pool.ntp.org

date >> /root/pbx-install.log
echo "Downloading PBX downloadlist." >> /root/pbx-install.log

wget --read-timeout=70 "$DOWNLOADLISTURL" -O /var/pbx-load/download-list
cd /usr/src
wget --read-timeout=70 -i /var/pbx-load/download-list
#mv pbx* /var/pbx-load/
chmod +x /var/pbx-load/*.sh

mkdir /etc/pbx
cp /root/anaconda-ks.cfg /etc/pbx/
echo "Install date=$INSTALLDATE" >> /etc/pbx/install-info
echo "Install type=$INSTALLTYPE" >> /etc/pbx/install-info
echo "Hardware type=$PBXHWTYPE" >> /etc/pbx/install-info
echo "PBX Install Version=$PBXVERSION" >> /etc/pbx/install-info
echo "PBX Installer Script Version=$INSTSCRIPTVERSION" >> /etc/pbx/install-info
echo "PBX Update Version=$PBXVERSION" >> /etc/pbx/install-info
chkconfig --list | grep on > /etc/pbx/oem-chkconfig.txt

chkconfig bluetooth off
chkconfig cups off
chkconfig firstboot off
chkconfig gpm off
chkconfig hidd off
chkconfig ip6tables off
chkconfig irqbalance off
chkconfig kudzu off
chkconfig lvm2-monitor off
chkconfig mcstrans off
chkconfig nfslock off
chkconfig pcscd off
chkconfig portmap off
chkconfig rawdevices off
chkconfig restorecond off
chkconfig rpcgssd off
chkconfig rpcidmapd off
chkconfig smartd on
chkconfig yum-updatesd off

if [ ! $PBXHWTYPE = "x86 PC" ]; then
	chkconfig apmd off
	chkconfig cpuspeed off
	chkconfig microcode_ctl off
	chkconfig smartd off
fi

######### End Stage 1 --------------------
echo "Stage 1 downloads finished, now starting Stage 2" >> /root/pbx-install.log
echo "Stage 1 downloads finished, now starting Stage 2"

######## Cleanup startup and Reboot with new kernel so Dahdi compiles correctly:
sed -i "s|wget http://$SRCSERVER/pbx-load/pbx-install.sh -O /root/pbx-install.sh -T 30 -t 1| |" /etc/rc.local
sed -i "s|chmod +x /root/pbx-install.sh| |" /etc/rc.local
sed -i "s|/root/pbx-install.sh| |" /etc/rc.local

touch /tmp/stg2
################ PBX install - Stage 2: -------------
###### Set some variables:
FPBXVER=freepbx-2.11.0
ASTBRANCH="11.6"
echo "------------------------------------------" >> /root/pbx-install.log
echo " " >> /root/pbx-install.log
echo "PBX Install beginning stage 2" >> /root/pbx-install.log
date >> /root/pbx-install.log
echo "------------------------------------------" >> /root/pbx-install.log

###### Install Webmin and other stuff:
cd /usr/src
rpm -ivh lame-*.rpm
#rpm -ivh webmin-*.noarch.rpm
rm -f *.rpm
sed -i 's|port=10000|port=9999|' /etc/webmin/miniserv.conf
###### Install fail2ban
# https://github.com/fail2ban/fail2ban/downloads
echo "Installing fail2ban" >> /root/pbx-install.log
tar xzf fail2ban*
cd fail2ban-*
python setup.py install
cp files/redhat-initd /etc/init.d/fail2ban

echo "Installed Lame, Webmin, Fail2ban" >> /root/pbx-install.log

###### Untar asterisk/zaptel/dahdi/sound/freepbx packages ------------------------
cd /usr/src/
tar zxf asterisk-*.tar.gz
tar zxf freepbx-2.*.tar.gz
tar -xjf mpg123-*.tar.bz2
### Dahdi or Zaptel??:
tar zxf dahdi-linux-complete-current.tar.gz

# Note some info for the initial install on the record:

echo "untarred all asterisk files, now beginning asterisk install and deps" >> /root/pbx-install.log

cd /usr/src/mpg123-1.21.0
make clean
./configure
make
make install

echo "Now compiling Dahdi drivers" >> /root/pbx-install.log
date >> /root/pbx-install.log

cd /usr/src/dahdi-linux-complete-*
make all && make install && make config
chkconfig dahdi on
service dahdi start

echo "Now installing Asterisk" >> /root/pbx-install.log
date >> /root/pbx-install.log

cd /usr/src
useradd -c "Asterisk PBX" -d /var/lib/asterisk asterisk
mkdir /var/run/asterisk
mkdir /var/log/asterisk
chown -R asterisk:asterisk /var/run/asterisk
chown -R asterisk:asterisk /var/log/asterisk
chown -R asterisk:asterisk /var/lib/php/session/

#echo "Prep goog voice addons before asterisk compile:" >> /root/pbx-install.log
	yum install -y subversion
#	wget http://repo.smpltechno.com:8888/tools/gv-setupwizard.sh
#	cp gv-setupwizard.sh /usr/local/sbin/gv-setupwizard
#	chmod +x /usr/local/sbin/gv-setupwizard
#echo "Installing iksemel - dependency for gtalk" >> /root/pbx-install.log
#	wget http://iksemel.googlecode.com/files/iksemel-1.4.tar.gz
#	tar -zxf iksemel-1.4.tar.gz
#	cd /usr/src/iksemel-1.4
#	./configure
#	make && make all && make install
echo "Beginning Asterisk compile" >> /root/pbx-install.log
date >> /root/pbx-install.log
	cd /usr/src/asterisk-$ASTBRANCH.*
	contrib/scripts/get_mp3_source.sh
	contrib/scripts/get_ilbc_source.sh
	#make clean
	./configure  
	make menuselect.makeopts
	menuselect/menuselect --enable app_mysql --enable cdr_mysql --enable format_mp3 --enable EXTRA-SOUNDS-EN-GSM menuselect.makeopts
	make && make install

#Fix buggy module:
echo "noload => chan_mgcp.so" >> /etc/asterisk/modules.conf

echo "Finished compiling asterisk, now installing sounds" >> /root/pbx-install.log
echo "--------------------------------------------------------" >> /root/pbx-install.log

## Sound files: 
chown -R asterisk:asterisk /var/lib/asterisk/sounds
ln -s /var/lib/asterisk/moh /var/lib/asterisk/mohmp3

echo "Finished compiling asterisk sounds and extras, fixing some files and DB stuff" >> /root/pbx-install.log

###### Fixing config stuff:
/etc/init.d/mysqld start
/etc/init.d/httpd start
/etc/init.d/dahdi start
sed -i "s/User apache/User asterisk/" /etc/httpd/conf/httpd.conf
sed -i "s/Group apache/Group asterisk/" /etc/httpd/conf/httpd.conf
sed -i "s/AllowOverride None/AllowOverride All/" /etc/httpd/conf/httpd.conf
sed -i "s/post_max_size = 8M/post_max_size = 80M/" /etc/php.ini
sed -i "s/upload_max_filesize = 2M/upload_max_filesize = 80M/" /etc/php.ini
cd /usr/src/freepbx-*
mysqladmin create asterisk
mysqladmin create asteriskcdrdb
mysql asterisk < SQL/newinstall.sql
mysql asteriskcdrdb < SQL/cdr_mysql_table.sql
mysqladmin -u root password 'passw0rd'

echo "Installing Freepbx" >> /root/pbx-install.log

######## Put all files in the correct places, fix files, set service startups:
echo "------------------------------------------------" >> /root/pbx-install.log
echo "Now extracting the following files:" >> /root/pbx-install.log
cd /
tar xzvf /var/pbx-load/pbx-load-file.tgz >> /root/pbx-install.log
echo "------------------------------------------------" >> /root/pbx-install.log
cp /etc/sysconfig/iptables /var/pbx-load/iptables.smpl-orig
echo "/etc/init.d/iptables restart" >> /etc/rc.local
chmod +x /etc/rc.local

#Fix asterisk for OpenVZ:
if [ $PBXHWTYPE = OpenVZ ]; then 
mknod /dev/tty9 c 4 9
sed -i 's/TTY=9/#TTY=9/g' /usr/sbin/safe_asterisk
sed -i 's/chown asterisk \/dev\/tty9/#chown asterisk \/dev\/tty9/g' /etc/init.d/asterisk
sed -i 's/\/sbin\/start_udev/#\/sbin\/start_udev/g' /etc/rc.d/rc.sysinit
sed -i 's/\/usr\/sbin\/fxotune -s/#\/usr\/sbin\/fxotune -s/g' /etc/rc.local
fi

## Install Freepbx
cp /usr/src/freepbx-2.*/amportal.conf /etc/amportal.conf
cat >> /etc/amportal.conf << EOF
## Added by pbx installer:

AMPDBNAME=asterisk
AMPDBUSER=root
AMPDBPASS=passw0rd
ASTETCDIR=/etc/asterisk
ASTMODDIR=/usr/lib/asterisk/modules
ASTVARLIBDIR=/var/lib/asterisk
ASTAGIDIR=/var/lib/asterisk/agi-bin
ASTSPOOLDIR=/var/spool/asterisk
ASTRUNDIR=/var/run/asterisk
ASTLOGDIR=/var/log/asterisk
AMPDISABLELOG=true
ZAP2DAHDICOMPAT=true
ARI_ADMIN_PASSWORD=405540
EOF
pear install db
/usr/sbin/safe_asterisk
cd /usr/src/freepbx-2.*
./install_amp --username root --password passw0rd
echo '/usr/local/sbin/amportal start' >> /etc/rc.local
ln -s /usr/local/sbin/amportal /usr/sbin/amportal
##### Fix a security hole in SIP:
echo "alwaysauthreject=yes" >> /etc/asterisk/sip_custom.conf

amportal start

###################################### Running stage 3 tools installs:
#echo "PBX Install beginning stage 3 subscript" >> /root/pbx-install.log
#/var/pbx-load/./install-tools.sh
#sed -i "s/AMP Administration/PBX Administration/" /var/www/html/index.php

######### Set all service startups
echo "Setting startup services and fixing permissions" >> /root/pbx-install.log
chkconfig dahdi on
chkconfig fail2ban on
chkconfig fop2 on
chkconfig iptables on
chkconfig named on
chkconfig --level 345 xinetd on
chkconfig --level 345 tftp on 
chkconfig httpd on
chkconfig mysqld on


###### Set file permissions, ownerships, and formats
echo "Setting file permissions, ownerships, and formats" >> /root/pbx-install.log
chmod +x /etc/cron.*
dos2unix /etc/cron.*
chmod +x /usr/local/sbin/*
dos2unix /usr/local/sbin/*
chown -R asterisk:asterisk /var/www/html/

####### Determine file system layout and store variables
echo "------------------------------------------------" >> /root/pbx-install.log
echo "Determine file system layout and store variables" >> /root/pbx-install.log
KSINSTALLTYPE=`cat /etc/pbx/install-info |grep "KS Inst" |cut -d':' -f2`
if [ $KSINSTALLTYPE = normal ]; then
	ROOTPART="/dev/sda2"
	BOOTPART="/dev/sda1"
	SWAPPART="/dev/sda3"
elif [ $KSINSTALLTYPE = EC2AMI ]; then
	ROOTPART="/dev/xvda1"
	BOOTPART="/dev/sda1"
	SWAPPART="/dev/sda3"
elif [ $KSINSTALLTYPE = raid ]; then
	ROOTPART="/dev/md0"
	BOOTPART="/dev/md1"
	SWAPPART="/dev/md2"
elif [ $KSINSTALLTYPE = raidstore ]; then
	ROOTPART="/dev/md0"
	BOOTPART="/dev/md1"
	SWAPPART="/dev/md2"	
	VARPART="/dev/md3"	
else [ $KSINSTALLTYPE = store ]
	ROOTPART="/dev/sda2"
	BOOTPART="/dev/sda1"
	SWAPPART="/dev/sda3"
	VARPART="/dev/sda4"
fi
echo "ROOTPART=$ROOTPART" >> /etc/pbx/install-info
echo "BOOTPART=$BOOTPART" >> /etc/pbx/install-info
echo "SWAPPART=$SWAPPART" >> /etc/pbx/install-info
echo "VARPART=$VARPART"	>> /etc/pbx/install-info
sed -i "s|ROOTPART=/dev/sda2|ROOTPART=$ROOTPART|" /usr/local/sbin/disk-space.sh
sed -i "s|BOOTPART=/dev/sda1|BOOTPART=$BOOTPART|" /usr/local/sbin/disk-space.sh
sed -i "s|SWAPPART=/dev/sda3|SWAPPART=$SWAPPART|" /usr/local/sbin/disk-space.sh
sed -i "s|ROOTPART=/dev/sda2|ROOTPART=$ROOTPART|" /usr/local/sbin/status
sed -i "s|BOOTPART=/dev/sda1|BOOTPART=$BOOTPART|" /usr/local/sbin/status
sed -i "s|SWAPPART=/dev/sda3|SWAPPART=$SWAPPART|" /usr/local/sbin/status

##### Store some more system setup info for future use:
echo "Store some more system setup info for future use" >> /root/pbx-install.log
wget http://ipecho.net/plain -O /tmp/my-ip
echo -n "PBX public IP=" >> /etc/pbx/install-info
echo `cat /tmp/my-pub-ip` >> /etc/pbx/install-info
ASTINSTVERS=`/usr/sbin/asterisk -rx 'core show version' | awk '{print $2}' | grep '.'`
echo "Initial install Asterisk version=$ASTINSTVERS" >> /etc/pbx/install-info
DAHDIINSTVERS=`dahdi_cfg -v 2>/dev/null |grep 'DAHDI V' |awk ' { print $3}' `
echo "Initial install Dahdi version=$DAHDIINSTVERS" >> /etc/pbx/install-info
echo "Initial install FreePBX version=$FPBXVER" >> /etc/pbx/install-info
echo " " >> /etc/pbx/install-info

######## Clean up install scripts
rm /tmp/stg2
#clean up source downloads:
rm -f /usr/src/*.tgz
#rm -f /root/pbx-install.sh

echo "------------------------------------------------" >> /root/pbx-install.log
echo " "
echo "Installation complete, now rebooting." >> /root/pbx-install.log
echo "Installation complete, now rebooting."

#shutdown -r now
