#!/bin/sh
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

#Joe Roper 11:22 18 February 2009 joe.roper@gmail.com
#Install script for Webmeetme version 3.1.0 for PBX in a Flash


#Install Webmeetme 3

clear
echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING"
echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "This script assumes you have not changed the default root username For MySQL"
echo "If you have, e.g. if you use PBX-Management, press CTRL-C to exit"
echo "Then change the MySQL root password in the script to suit your installation."
echo " "
echo "If an earlier copy of web-meetme 3 is already installed, then you should inspect"
echo "this script and modify it, or modify your installation before executing it."
echo "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
#read -p "Press any key to continue or ctrl-C to exit"

#Change passw0rd below for your MySQL root password if you have changed it from the default.
MYSQLROOTPASSWORD=passw0rd

cd /usr/src

wget http://kent.dl.sourceforge.net/sourceforge/web-meetme/Web-MeetMe_v3.1.0.tgz
tar zxfv Web-MeetMe_v3.1.0.tgz 

cd web-meetme/cbmysql/

mysqladmin -uroot -p$MYSQLROOTPASSWORD create meetme

mysql -uroot -p$MYSQLROOTPASSWORD  -e "GRANT ALL PRIVILEGES ON meetme.* TO meetme@localhost IDENTIFIED BY 'meetme3'"

mysql -uroot -p$MYSQLROOTPASSWORD meetme < db-table-create-v5.txt

RESULT=`/usr/bin/mysql -umeetme -pmeetme3<<SQL

use meetme
INSERT INTO meetme.user 
	(first_name, last_name, email, password, admin)
	VALUES ('Meetme', 'Admin', 'root@localhost', 'password', 'Admin');
	(first_name, last_name, email, password, admin)
	VALUES ('Meetme', 'Admin', 'maint', '123qwe', 'Admin');
quit
SQL`

#make cbmysql
make
make install

#copy and modify cbmysql to suit
cp cbmysql.conf /etc/asterisk
chown asterisk:asterisk /etc/asterisk/cbmysql.conf

sed -i 's/sock=\/tmp\/mysql.sock/\/var\/lib\/mysql\/mysql.sock/g'  /etc/asterisk/cbmysql.conf
sed -i 's/password=/password=meetme3/g'  /etc/asterisk/cbmysql.conf
sed -i 's/user=/user=meetme/g'  /etc/asterisk/cbmysql.conf

#Modify defines.php
#get rid of the php errors
cd ../lib
sed -i '/error_reporting(E_ALL & ~E_NOTICE);/d' defines.php
sed -i '/WEBROOT/ i\error_reporting(E_ALL & ~E_NOTICE);' defines.php 
sed -i 's/"adLDAP"/"sqldb"/g'  defines.php
sed -i 's/"PST\/PDT"/"GMT"/g'  defines.php
sed -i 's/192.168.0.1/localhost/g'  defines.php
sed -i 's/"default"/"from-internal"/g'  defines.php
sed -i 's/"CLIENT"/"SERVER"/g'  defines.php

#Modify cbend.php for freepbx

sed -i 's/9999@mm-announce/s@mm-announce/g' cbEnd.php
sed -i 's/default/mm-end/g' cbEnd.php

#Set up database credentials
sed -i 's/root/meetme/g'  database.php
sed -i  "s/''/'meetme3'/g" database.php

#Fix call operator
cd ..
sed -i 's/$invite_num;/$invite_num . "@" . OUT_CONTEXT;/g'  call_operator.php

#fix conf_listen.php
sed -i 's/$FG_QUERY/$FG_COL_QUERY/g'  conf_listen.php


#PHPAGI and Manager.conf
cd phpagi
touch /etc/asterisk/phpagi.conf
chown asterisk:asterisk /etc/asterisk/phpagi.conf

echo "

[phpagi]
#enable debuging
debug=true
#use internal error handler
error_handler=true
#mail errors to
admin=root@localhost
#host name of this server
hostname=localhost
# temporary directory for storing temporary output
tempdir=/var/spool/asterisk/tmp/

[asmanager]
# server to connect to
server=localhost
# default manager port
port=5038
#username for login
username=meetme
#password for login
secret=meetme3
" >> /etc/asterisk/phpagi.conf

#Add Manager settings 

echo "

[phpagi]
secret = phpagi
deny=0.0.0.0/0.0.0.0
permit=127.0.0.1/255.255.255.0
read = system,call,log,verbose,command,agent,user
write = system,call,log,verbose,command,agent,user

[MeetMe]
secret = meetme3
deny=0.0.0.0/0.0.0.0
permit=127.0.0.1/255.255.255.0
read = system,call,log,verbose,command,agent,user
write = system,call,log,verbose,command,agent,user

" >> /etc/asterisk/manager_custom.conf

cd ../sounds
chown asterisk:asterisk conf*.wav
cp conf*.wav /var/lib/asterisk/sounds/

#Prepare meetme directory
#tar up old install
mkdir /var/www/html/web-meetme

cd /usr/src/web-meetme

cp -r css/ /var/www/html/css
chown -R asterisk:asterisk /var/www/html/css
mv *.php *.txt css/ images/ lib/ phpagi/ index.html /var/www/html/web-meetme
#copy in a missing file for Webmeetme
cp /var/pbx_load/misc/clear.gif /var/www/html/web-meetme/images
chown -R asterisk:asterisk /var/www/html/web-meetme

#Create Dial Plan

echo "

[mm-announce]
exten => s,1,Set(CALLERID(name)="MMGETOUT")
exten => s,n,Answer
exten => s,n,Playback(conf-will-end-in)
exten => s,n,Playback(digits/5)
exten => s,n,Playback(minutes)
exten => s,n,Hangup

[mm-end]
;Used by cbEnd script to play end of conference warning
exten => _mmplay.,1,Answer
exten => _mmplay.,2,MeetMe(${EXTEN:6}|dq)
exten => _mmplay.,3,Hangup

[custom-meetme3]
exten => s,1,Answer
exten => s,n,Wait(1)
exten => s,n,CBMysql()
exten => s,n,Hangup

" >> /etc/asterisk/extensions_custom.conf

RESULT=`/usr/bin/mysql -uroot -p$MYSQLROOTPASSWORD <<SQL

use asterisk
INSERT INTO custom_destinations 
	(custom_dest, description, notes)
	VALUES ('custom-meetme3,s,1', 'Web-Meetme', '');
quit
SQL`


# Add a menu item to kennon soft interface
sed -i '/asteridex/ i\1,web-meetme,./web-meetme,Web MeetMe Conference,ico_meetme.png' /var/www/html/welcome/.htindex.cfg

#reload asterisk
asterisk -rx "module reload"

# Add some Apache protection, probably not necessary, as SQL injection issues are reported as fixed.
#removed by john

#restart httpd to pickup changes
service httpd restart

#Copy in some branding 
#rm /var/www/html/web-meetme/images/asterisk.gif

echo " "
echo " "
echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "Web meetme 3 installation complete"
echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo " "
echo "Web Meetme is covered by htaccess and by database authentication"
echo "Use your meetme, wwwadmin or maint password to gain access to the front page"
echo "Then authenticate to web meetme using root@locahost and password"
echo "You can then add extra users"
echo " "
echo "In FreePBX there is a new custom destination that you can use to direct"
echo "conference users to the conference either by IVR or by direct DID"
