#!/bin/bash
clear
echo "v1.2.8 This script downloads and installs common addons for source based systems"
echo "[1;31mYou should [4mONLY[0m [1;31mrun this on a new pre-production system"
echo "[1;31mDo [4mNOT[0m [1;31mrun this on an existing production system[0m"
echo "This script is Copyright 2010 John Hyde, "
echo "with no permission to use or distribute unless otherwise permitted in writing"
echo "to request such permission email: j.a.hyde@gmail.com"
echo "This will download several items taking 5-20 minutes depending on your bandwidth"
echo "You will need to complete some interactive questions once the script finishes"
echo "[1;32;4mThe following are auto-installed:____________________________________[0m"
echo "|[0m Aastra and/or Polycom tftp configurations                          [1;32m|"
echo "|[0m Sangoma or Rhino telephony drivers                                 [1;32m|"
echo "|[0m Caller ID Lookup module for FreePBX                                [1;32m|"
echo "|[0m New Meetme module for FreePBX                                      [1;32m|"
echo "|[0m Bulk Extensions module for FreePBX                                 [1;32m|"
echo "|[0m Mondoarchive disk imaging system                                   [1;32m|"
echo "|[0m Scheduled removal script for FreePBX backups                       [1;32m|"
echo "|[0m Disk space checking script- sends email if used disk=80% or more   [1;32m|"
echo "|[0m Abnormal call notification script - prevents excessive phone bills [1;32m|"
echo "|[0m Base config for FreePBX (Available in FreePBX Backup/Restore       [1;32m|"
echo "|[0m SmplPBX Dashboard                                                  [1;32m|"
echo "|[0m Enhanced  Status scripts, asterisk sound conversion scripts        [1;32m|"
echo "|[0m  Many other scripts are downloaded, but not run,                   [1;32m|"
echo "|[0m  to see all scripts, at command prompt type: ls /root/tools        [1;32m|"                                                                       
echo "|____________________________________________________________________|[0m"
if [ ! -e /root/tools ]; then
mkdir /root/tools
fi
######### Log variables and log initialization:
LOGNAME="/root/tools/install.log"
DATETIME="$(date +%Y%m%d%k%M)"
LOGLINES="--------------------------------------------------------"
echo "Press q to quit log reader" >$LOGNAME
echo $LOGLINES >>$LOGNAME
echo "Now starting install process" $DATETIME >>$LOGNAME
echo $LOGLINES >>$LOGNAME
echo ""
echo ""
echo "Please enter your admin email for critical system notifications"
echo "This can be changed later by typing: it-email"
read ADMINEMAIL
if [ $ADMINEMAIL = "" ]; then
	ADMINEMAIL=root@localhost
fi
echo $ADMINEMAIL > /etc/pbx/adminemail
############ Optional System Updates ############
#------------------------------------------------------------------------------#
############ Install full template??: ############
	while true; do
echo ""
echo ""
echo "Would you like to install the full system template?..."
echo "Select NO if this is not a new install... [y]es or [n]o?"
read INSTALLTEMPLATE
	echo "Install full template = $INSTALLTEMPLATE" >>$LOGNAME
case "$INSTALLTEMPLATE" in
	"y" |"Y")
	INSTALLTEMPLATE="y"
	break
	;;
	"n" |"N" )
	INSTALLTEMPLATE="n" 
	break
	;;
	"q" |"Q" )
	echo "Exiting."
	exit 0
	;;
	* )
	echo ""
	echo "Sorry, try again."
	;;
esac
done
########################## phones and trunks:
echo "[1;32;4m	Now you need to select your phones and trunk cards[0m"
############ Phone selection ############
	########### Aastra ##########
while true; do
echo ""
echo ""
echo "Will you be using Aastra IP Phones?... [y]es or [n]o?"
read AASTRAINST
	echo "Using Aastra phones = $AASTRAINST" >>$LOGNAME
case "$AASTRAINST" in
	"y" |"Y")
	AASTRAINST="y"
	break
	;;
	"n" |"N" )
	AASTRAINST="n" 
	break
	;;
	"q" |"Q" )
	echo "Exiting."
	exit 0
	;;
	* )
	echo ""
	echo "Sorry, try again."
	;;
esac
done
	######## Polycom ##########
while true; do
echo ""
echo ""
echo "Will you be using Polycom IP Phones?... [y]es or [n]o?"

read POLYCOMINST
echo "Using Polycom phones = $POLYCOMINST" >>$LOGNAME
case "$POLYCOMINST" in
	"y" |"Y")
	POLYCOMINST="y"
	break
	;;
	"n" |"N" )
	POLYCOMINST="n" 
	break
	;;
	"q" |"Q" )
	echo "Exiting."
	exit 0
	;;
	* )
	echo ""
	echo "Sorry, try again."
	;;
esac
done
############# Telephony Card Selection #################
echo ""
echo ""
echo "Now you need to select your trunk cards, Digium is already supported natively."
while true; do
	echo ""
	echo ""
	echo "Please select from Rhino or Sangoma, nothing is installed for Digium or VoIP only:"
	echo ""
	echo "[1] Sangoma"
	echo "[2] Rhino"
	echo "[3] Digium or VoIP only"
	echo "[q] Quit NOW"
read TRUNKCARD
	echo "Selected Trunk type = $TRUNKCARD" >>$LOGNAME
case "$TRUNKCARD" in
	"1")
	SANGOMAINST="y"
	break
	;;
	"2" )
	RHINOINST="y" 
	break
	;;
	"3" )
	DIGIUMINST="y" 
	break
	;;
	"q" |"Q" )
	echo "Exiting."
	exit 0
	;;
	* )
	echo ""
	echo "Sorry, try again."
	;;
esac
done
echo $LOGLINES >>$LOGNAME
echo "[1;32;4m	Now beginning file downloads and pre-installs, come back in 10-15 minutes.[0m"
echo "Now beginning file downloads and pre-installs" $DATETIME >>$LOGNAME
echo ""
cd /root/tools
 wget --read-timeout=70 http://dist.rhinoequipment.com/setup-rhino-se/latest >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/install-sangoma.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/install-polycom.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/setup-polycom >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/make-directory-xml.sh >>$LOGNAME
 wget --read-timeout=70 http://65.205.71.13/2.3.0/install-aastra-xml.x.gz >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/demo-user.prf >>$LOGNAME
 wget --read-timeout=70 http://projects.colsolgrp.net/attachments/download/413/superfecta-2.2.4.tgz >>$LOGNAME
 wget --read-timeout=70 http://projects.colsolgrp.net/attachments/download/55/concurrentcalls-2.0.5.tgz
 wget --read-timeout=70 http://www.freepbx.org/trac/browser/contributed_modules/release/bulkextensions-2.9.0.0.tgz?format=raw >>$LOGNAME
 wget --read-timeout=70 http://projects.colsolgrp.net/attachments/download/304/endpointman-2.0.0.tgz
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/FPBX-PassWarn.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/FPBX-PassWarn.tgz >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/install-fop2.sh >>$LOGNAME
 wget --read-timeout=70 http://projects.colsolgrp.net/attachments/download/57/webmeetme-1.0.1.tgz >>$LOGNAME 
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/install-wmm3.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/meetme-image.tgz >>$LOGNAME
# wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/freepbx-base-restore.tar.gz >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/smplwwwmod.tgz >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/AbnormalCallVolume-1.0-1.noarch.rpm  >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/setup-gmail.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/install-sugarcrm.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/abnmcalls.tgz >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/install-mondo.sh >>$LOGNAME
 wget --read-timeout=70 http://repo.smpltechno.com:8888/tools/README >>$LOGNAME
 gunzip *.x.gz >>$LOGNAME
 chmod +x *.x >>$LOGNAME
 chmod +x *.sh >>$LOGNAME
 dos2unix *.sh
echo "[1;32m      Initial script downloads finished[0m"
echo "      Initial script downloads finished" $DATETIME >>$LOGNAME
echo $LOGLINES >>$LOGNAME
echo ""
cd /
 tar xzf /root/tools/smplwwwmod.tgz
################ Download/Install system template if selected:
if [ "$INSTALLTEMPLATE" = "y" ]; then
  wget --read-timeout=70 http://repo.smpltechno.com:8888/pbx-load/freepbx-full-tmplt.tgz
echo "[1;32m      Installing system template[0m"
echo "Installing system template" $DATETIME >>$LOGNAME
service mysqld stop
service httpd stop
amportal stop
cd /
tar xzvf /root/tools/freepbx-full-tmplt.tgz
service mysqld start
service httpd start
amportal start
echo $LOGLINES >>$LOGNAME
echo "Installed system template" $DATETIME >>$LOGNAME
fi
################  Lets start with FreePBX and its addons:
if [ "$INSTALLTEMPLATE" = "n" ]; then
while true; do
######   That was a while statement to check for template and bypass the following redundant installs
################ Lets start with FreePBX and its addons:
#	if [ "$UPDATEFPBX" = "y" ]; then
#echo "[1;32m      Upgrading to FreePBX 2.8 [0m"
#echo "      Upgrading to FreePBX 2.8" $DATETIME >>$LOGNAME
#	cd /usr/src/
#	wget http://mirror.freepbx.org/freepbx-2.8.0.tar.gz >>$LOGNAME
#	tar zxvf freepbx-2.8.0.tar.gz >>$LOGNAME
#	cd freepbx-2.8.0 >>$LOGNAME
#	./install_amp
#echo "      Successfully upgraded to FreePBX 2.8" $DATETIME >>$LOGNAME
#  echo $LOGLINES >>$LOGNAME
#	fi
echo ""
echo "[1;32m      Copying FreePBX base settings to restore directory[0m"
	if [ ! -e /var/lib/asterisk/backups ]; then
	mkdir /var/lib/asterisk/backups >>$LOGNAME
	fi
	if [ ! -e /var/lib/asterisk/backups/base-restore ]; then
	mkdir /var/lib/asterisk/backups/base-restore >>$LOGNAME
	fi
	cp /root/tools/freepbx-base-restore.tar.gz /var/lib/asterisk/backups/base-restore/ >>$LOGNAME
####  Install FreePBX addon modules:
echo "[1;32m      Installing the following FreePBX addon modules:"
echo "			CID superfecta Freepbx module"
echo "     		Bulk Extension Freepbx module"
echo "			Meetme3 module Freepbx module"
echo "			Concurrent Call reporting module for FreePBX"
echo "			Endpoint Manager for Freepbx[0m"
	cd /var/www/html/admin/modules
	tar xzvf /root/tools/superfecta-2.2.4.tgz >>$LOGNAME
	tar xzvf /root/tools/bulkextensions-2.9.0.0.tgz?format=raw >>$LOGNAME
#      http://www.fonicaprojects.com/wiki/index.php/Scripted_Install:_Web_MeetMe_for_PBXIAF
#	rm -rf /var/www/html/meetme
	tar xzvf /root/tools/webmeetme-1.0.1.tgz >>$LOGNAME
	/root/tools/./install-wmm3.sh
	tar xzvf /root/tools/concurrentcalls-2.0.5.tgz
#   installing endpoint manager module: 
	tar xzvf /root/tools/endpointman-2.0.0.tgz
	chown -hR root:asterisk /tftpboot 
	chmod g+w /tftpboot
echo "[1;32m      Killing unnecessary MySQL warnings in FreePBX[0m"
	cd /
	cp /var/www/html/admin/header.php /var/www/html/admin/header.php.bak >>$LOGNAME
	cp /var/www/html/admin/common/db_connect.php /var/www/html/admin/common/db_connect.php.bak >>$LOGNAME
	tar xzvf /root/tools/FPBX-PassWarn.tgz >>$LOGNAME

echo "Done with FreePBX and its addons" $DATETIME >>$LOGNAME
echo $LOGLINES >>$LOGNAME
break;
done
fi
######### While statement done on line above, template finished here
################  Done with FreePBX and its addons:       ######################
echo "[1;32m      Install FOP2 Flash Operator Panel[0m"
	/root/tools/./install-fop2.sh >>$LOGNAME
echo "[1;32m      Install Rhino drivers[0m"
echo  "     Install Rhino drivers" $DATETIME >>$LOGNAME
echo $LOGLINES >>$LOGNAME
 install -m 755 setup-rhino /usr/local/sbin/setup-rhino
echo "[1;32m      Installing IP Phone files:[0m"
  ################# initial polycom setup
 if [ "$POLYCOMINST" = "y" ]; then
	echo  "     Installing Polycom firmwares and configs" $DATETIME >>$LOGNAME
	/root/tools/./install-polycom.sh $DATETIME >>$LOGNAME
 fi
 echo $LOGLINES >>$LOGNAME
if [ "$AASTRAINST" = "y" ]; then
	echo  "     Installing Aastra firmwares and xml configs" $DATETIME >>$LOGNAME
	/root/tools/./install-aastra-xml.x beta
	mv /var/www/html/aastra/asterisk/demo-user.prf /var/www/html/aastra/asterisk/demo-user.prf.oem  $DATETIME >>$LOGNAME
	cp /root/tools/demo-user.prf /var/www/html/aastra/asterisk/demo-user.prf  $DATETIME >>$LOGNAME
	echo "[1;32m      Aastra xml config files and firmware installed:[0m"
	echo $LOGLINES >>$LOGNAME
 fi
echo "[1;32m      Installing make-sounds script to convert mp3/wav to native asterisk sln files[0m"
echo  "     Installing make-sounds script to convert mp3/wav to native asterisk sln files" $DATETIME >>$LOGNAME
## Installing ffmpeg and for audio conversion:
cd /usr/src/
svn export svn://svn.mplayerhq.hu/ffmpeg/trunk ffmpeg
cd ffmpeg
./configure
make && make install
mkdir /root/prompts
mkdir /root/transcodes
#mv /root/tools/make-sounds.sh /usr/local/sbin/make-sounds
###########        Done installing ffmpeg
echo  "     ffmpeg and make-sounds script installed" $DATETIME >>$LOGNAME
echo "[1;32m      Installing weekly backup removal script:[0m"
echo  "     Install weekly backup removal script" $DATETIME >>$LOGNAME
 cd /
 tar xzvf /root/tools/rmbackups.tgz
echo "[1;32m      Install disk space script[0m"
echo  "     Install disk space script" $DATETIME >>$LOGNAME
echo "       - checks every 5 minutes for disk space exceeding 80% and sends email:[0m"
sed -i "s/root@localhost/$ADMINEMAIL/" /usr/local/sbin/disk-space.sh
echo "[1;32m      Install Abnormal call volume notification "
echo "#      - if daily calls exceed 20% an email is sent:[0m"
echo  "     Installing abnormal call volume script" $DATETIME >>$LOGNAME
 cd /
 rpm -Uvh /root/tools/AbnormalCallVolume-1.0-1.noarch.rpm
 service crond restart
 tar xzvf /root/tools/abnmcalls.tgz
 sed -i "s/root@localhost/$ADMINEMAIL/" /usr/local/sbin/abnormal.php
echo "[1;32m      Install dashboard mods:[0m"
echo  "     Installing dashboard mods" $DATETIME >>$LOGNAME
 cd /
 tar xzvf /root/tools/meetme-image.tgz
echo "[1;32m      Update message of the day and Status scripts[0m"
echo  "     Update message of the day and Status scripts" $DATETIME >>$LOGNAME
echo "Turning off un-needed grub images"
sed -i 's|splashimage|#splashimage|'  /boot/grub/menu.lst 
 echo ""
#while true; do

### Install Mondo archive disk backup software:
 echo $LOGLINES >>$LOGNAME
if [ `cat /etc/pbx/install-info |grep -o "x86 PC"` = "x86 PC" ]; then
 echo  "     Now installing Mondo archive" $DATETIME >>$LOGNAME
 /root/tools/./install-mondo.sh initialinstall
 echo  "     Mondo archive install complete" $DATETIME >>$LOGNAME
fi
 echo $LOGLINES >>$LOGNAME
echo "[1;32m Now running final setups:"
echo "Completing phone config setup and trunk config setups"
echo "Once complete you may want to check the FreePBX Restore page"
#  echo -n "Press ENTER to continue, or CTRL+C to quit[0m"
#    read CONFIRM
#      break;
#done
echo ""
echo "[1;32mInstalling additional Telephony card drivers as instructed...[0m"
 ############### setup-sangoma
if [ "$SANGOMAINST" = "y" ]; then
	kill `ps -A|awk '/asterisk/{print $1}'`
	/root/tools/./install-sangoma.sh
	echo "[1;32m	Successfully installed Sangoma drivers[0m"
fi
 ############### setup-rhino
 if [ "$RHINOINST" = "y" ]; then
	/usr/local/sbin/setup-rhino
	echo "[1;32m	Successfully installed Rhino drivers[0m"
 fi
###########
echo ""
echo "[1;32mInstalling phone configs as instructed...[0m"
 ################# setup-aastra
 if [ "$AASTRAINST" = "y" ]; then
	/usr/local/sbin/setup-aastra-xml
	echo "[1;32m	Successfully configured Aastra XML and tftpboot files[0m"
 fi
  ################# setup-polycom
 if [ "$POLYCOMINST" = "y" ]; then
	/usr/local/sbin/setup-polycom
	echo "[1;32m	Successfully configured Polcyom tftpboot files[0m"
 fi
 ###### Clean up any possible duplicate file downloads:
rm -f /root/tools/*.tgz.1
rm -f /root/tools/*.x.gz.1
rm -f /root/tools/*.sh.1
rm -f /root/tools/*.tgz.2
rm -f /root/tools/*.x.gz.2
rm -f /root/tools/*.sh.2
rm -f /usr/src/*.sh.1
rm -f /usr/src/*.tgz.1
echo ""
echo "" 
echo "[1;32m		All setups are now complete,"
echo "	you should reboot your system to finalize all settings"
echo "Please edit nano /etc/asterisk/disk-backup.conf to configure MondoArchive"
echo "You should also read /root/tools/README to see all items installed and usage notes[0m"
 
# Other sites of interest: 
# freepbx endpoint manager: http://pbxinaflash.com/forum/showthread.php?t=4514
exit 0