#!/bin/bash
echo "This script installs the latest Sangoma driver from source"
echo "This script will stop asterisk and all calls"
echo "Assumes Asterisk/Zaptel or Dhadi 32 bit installed from source, with sources in /usr/src"
echo "You need to edit the noted line below if Dhadi 64 bit"
echo ""
#while true
#  do
#    echo -n "Press enter to begin installation, or  CTRL+C to quit"
#    read CONFIRM
#      break;
#done
echo ""
yum install -y kernel-devel gcc byacc
amportal stop
service zaptel stop
service dahdi stop
wanrouter stop
cd /usr/src/
wget ftp://ftp.sangoma.com/linux/current_wanpipe/wanpipe-latest.tgz
tar -zxvf wanpipe-latest.tgz
cd /usr/src/wanpipe*
if [[ `cat /usr/src/zaptel*` == /usr/src/zaptel* ]]
then
	TRUNK=zaptel
  #This is for Zaptel
  echo "Zaptel is present!"
  echo "Now starting automated Sangoma install for Zaptel"
  ./Setup install --silent --protocol=TDM
else
	TRUNK=dahdi
  #This is for Dahdi
  echo "Dhadi is present!"
  echo "Now starting automated Sangoma install for Dhadi"
  ./Setup dahdi
  #    or ######################### edit below for 64 bit Dhadi - remove # sign ######################
  #./Setup dahdi --64bit_4GB 
fi
echo "Fix reboot lockups:"
cat > /etc/wanpipe/scripts/stop <<EOF
#!/bin/bash
amportal kill
EOF
wanrouter start
service $TRUNK start
amportal start
echo "The latest Sangoma Driver is now installed with generic settings for Analog and PRI"
echo "You may still need to run setup-sangoma to fully configure your card"

