#!/bin/sh
#
##############################################################################
#Install-mondo.sh This file will install the mondo backup system on most CentOS 5 or RHEL 5 compatible systems
#
#USE AT YOUR OWN RISK!!
#
#This script is for the community, and thus will be by such.
#While there is no guaranteed support, you can post/refer to
#this forum link for support from the community peers:
#  http://www.trixbox.org/forums/trixbox-forums/trixbox-projects/whole-disk-backup 
#
#All credit goes to the community
#"picking up open source where the source got closed"
##############################################################################
##############################################################################
#LICENSE
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
###############################################################################
#REVISIONS
#May 5 2008 Rev 0.1
# June 10 2008 Rev 0.2 dependencies removed from base CentOS, added to install process.
# July 1 2009 Rev 0.3 Updated Mondo and Mindi versions to current versions.
# July 7 2009 Rev 0.4 Added exclusion variables
# May 25 2010 Rev 0.5 Updated Mondo and Mindi versions to current versions.
# 
############################VARIABLE DEFINITIONS BEGIN########################

#<<<<<<<<<<<<<<<<<<<<<<<LOGGING PARAMETERS BEGIN>>>>>>>>>>>>>>>>>>>>>>>>>>>>
#This is what folder/logfile to write logging information to
LOGDIRNAME="/root/mondoinstall.log"

#This contains the date/time DO NOT MODIFY
LOGDATETIME="$(date +%Y%m%d%k%M)"

#This is a formatting string to make reading the logs easier
LOGLINES="======================================================="
#<<<<<<<<<<<<<<<<<<<<<<<LOGGING PARAMETERS END>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

## Check how script was called, then set variable for user prompting
if [ "$1" = "initialinstall" ]; then
	USERPROMPTS=0
else 
	USERPROMPTS=1
fi

###########################VARIABLE DEFINITIONS END###########################
#<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>
#< Don't edit below this line!!!!!!!!!!!!!         >
#<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>
clear
echo "**********************************************************************"
echo "*Welcome! This script will install the mondo complete backup solution*"
echo "*It will also install a script in your /etc/cron.weekly folder. This *"
echo "*script will run mondo and take the generated ISO files and copy them*"
echo "*to a remote ftp site and if chosen a local USB flash drive. The usb *"
echo "*feature is DISABLED BY DEFAULT! Once you have determined how big    *"
echo "*your ISO files are and you have a USB stick large enough then you   *"
echo "*can re-enable these feature.                                        *"
echo "*                    USE AT YOUR OWN RISK!!!                         *"
echo "*                    ^^^^^^^^^^^^^^^^^^^^^^^                         *"
echo "*                                                                    *"
echo "*Press Enter for more information or Ctrl-C to exit                  *"
echo "**********************************************************************"
if [ $USERPROMPTS = 1 ];then
read
fi
clear
echo "**********************************************************************"
echo "*There are many many variations possible with Mondo try typing       *"
echo "*mondoarchive at the cli prompt. The mondobackup.cron file is        *"
echo "*configured to provide DVD sized ISOs however it can be changed to   *"
echo "*support CD sized ISOs. You can also make backups from within the    *" 
echo "*mondo gui and burn directly to a local CDR or DVDR                  *"
echo "*                                                                    *"
echo "*This script is configured to provide a reliable whole disk approach *"
echo "*for Tribox but there are endless variations! If you create some     *"
echo "*new variation please post to the forum link below:                  *"
echo "*http://www.trixbox.org/forums/trixbox-forums/trixbox-projects/whole-disk-backup                 *"
echo "*or see docs here: http://mondorescue.org                            *"
echo "*                                                                    *"
echo "*Press Enter to begin or Ctrl-C to exit                              *"
echo "**********************************************************************"
if [ $USERPROMPTS = 1 ];then
read
fi

#####################Initialize Log File BEGIN############################
echo " " >>$LOGDIRNAME
#this enters a line in the log file to make it readable
echo $LOGLINES >>$LOGDIRNAME

echo "Installing Mondo software and control files " $LOGDATETIME >>$LOGDIRNAME
 
#this enters a line in the log file to make it readable
echo $LOGLINES >>$LOGDIRNAME

#####################Initialize Log FIle ENDS#############################

####################StartInstallation#####################################
#differential checking
if [ -e "/usr/src/mondo" ]
then
   echo "Old /usr/src/mondo folder exists! Now deleting it"
   rm -rvf /usr/src/mondo >>$LOGDIRNAME
fi
echo "Creating /usr/src/mondo folder"
mkdir /usr/src/mondo >>$LOGDIRNAME
echo "Now changing to /usr/src/mondo folder"
cd /usr/src/mondo >>$LOGDIRNAME

#Install extras before mondo
echo "Now installing cd & DVD tools" 
yum -y install cdrecord dvd+rw-tools >>$LOGDIRNAME

echo "Now installing samba-client"
yum -y install samba-client >>$LOGDIRNAME

#added June 10, 2008 rev .2
echo "Installing other Mondo dependencies"
yum install -y dosfstools >>$LOGDIRNAME
yum install -y mtools >>$LOGDIRNAME
yum install -y parted >>$LOGDIRNAME
yum install -y syslinux >>$LOGDIRNAME

#Install Mondo tools
echo "Now downloading mondo and all of it's components"
wget ftp://ftp.mondorescue.org/rhel/5/afio-2.4.7-1.i386.rpm >>$LOGDIRNAME
wget ftp://ftp.mondorescue.org/rhel/5/buffer-1.19-1.i386.rpm >>$LOGDIRNAME
wget ftp://ftp.mondorescue.org/rhel/5/mindi-busybox-1.7.3-1.rhel5.i386.rpm >>$LOGDIRNAME
wget ftp://ftp.mondorescue.org/rhel/5/mindi-2.0.7.3-1.rhel5.i386.rpm >>$LOGDIRNAME
wget ftp://ftp.mondorescue.org/rhel/5/mondo-2.2.9.3-2.rhel5.i386.rpm >>$LOGDIRNAME
wget ftp://ftp.mondorescue.org/rhel/5/mondo-doc-2.2.8-1.rhel5.noarch.rpm >>$LOGDIRNAME
#download cron script
echo "Now downloading mondo cron job"
wget http://repo.smpltechno.com:8888/tools/mondobackup.cron >>$LOGDIRNAME

#Install Mondo tools
echo "Now installing mondo and all of it's components"
rpm -ivh afio-2.4.7-1.i386.rpm >>$LOGDIRNAME
rpm -ivh buffer-1.19-1.i386.rpm >>$LOGDIRNAME
rpm -ivh mindi-busybox-1.*.rhel5.i386.rpm >>$LOGDIRNAME
rpm -ivh mindi-2.*.rpm >>$LOGDIRNAME
rpm -ivh mondo-2.*.rpm >>$LOGDIRNAME
rpm -ivh mondo-doc-2.*.rhel5.noarch.rpm >>$LOGDIRNAME

#copy the mondobackup.cron file to the correct folder
echo "Copying mondobackup.cron to /etc/cron.weekly"
if [ -e "/etc/cron.weekly/mondobackup.cron" ]
then
  #hmm it is already there perhaps this is a re download.
  mv -vf /etc/cron.weekly/mondobackup.cron /root/oldmondobackup.cron >>$LOGDIRNAME
fi
mv -vf mondobackup.cron /etc/cron.weekly >>$LOGDIRNAME

#Make the permission changes to the file
echo "Making sure mondobackup.cron has the correct permissions"
chown root:root /etc/cron.weekly/mondobackup.cron >>$LOGDIRNAME
chmod +x /etc/cron.weekly/mondobackup.cron >>$LOGDIRNAME

#Create required directories
echo "Creating required backup directory \backup"
if [ -e "/backup" ]
then
   echo "/backup already exists" >>$LOGDIRNAME
else 
   mkdir -v /backup >>$LOGDIRNAME
   chown root:root /backup
   echo "Created /backup folder" >>$LOGDIRNAME
fi  
#Create required mount directory for SMB client
echo "Creating SMB mount point /mnt/smbmondo"
if [ -e "/mnt/smbmondo" ]
then
   echo "/mnt/smbmondo already exists" >>$LOGDIRNAME
else
   mkdir -v /mnt/smbmondo >>$LOGDIRNAME
   chown root:root /mnt/smbmondo
   #new someone reports error withfolder
   #chmod a=rwx /mnt/smbmondo
   echo "Created /mnt/smbmondo folder" >>$LOGDIRNAME
fi
#create mount point required for the USB key
echo "Creating USB Flashdrive mount point" >>$LOGDIRNAME
if [ -e "/mnt/usbmondo" ]
then
   echo "/mnt/usbmondo already exists" >>$LOGDIRNAME
else
   mkdir -v /mnt/usbmondo
   chown root:root /mnt/usbmondo
   #New someone reports error within folder
   #chmod a=rwx /mnt/usbmondo
   echo "Created /mnt/usbmondo  folder" >>$LOGDIRNAME
fi 
#this enters a line in the log file to make it readable
echo $LOGLINES >>$LOGDIRNAME
echo "Installation complete! Please edit the /etc/cron.weekly/mondobackup.cron file now" >>$LOGDIRNAME
#########################EndLogNowEnd################################
clear
echo "***************************************************************"
echo "*Install complete! You MUST REBOOT YOUR SYSTEM!               *"
echo "*                                                             *"
echo "*you also need to edit the cron job to schedule:              *"
echo "* nano /etc/cron.weekly/mondobackup.cron                      *"
echo "*                                                             *"
echo "*Press the Enter key to exit                                  *"
echo "***************************************************************"
if [ $USERPROMPTS = 1 ];then
read
fi