# Install script for Aastra XML scripts
# XML scripts 2.3.0
# Aastra fimware 2.6.0
# 
# Copyright Aastra Telecom 2010
# Released under the LGPL License
#

#!/bin/bash
cd /tmp
rm -rf aastra-install.log > /dev/null 2>/dev/null
touch aastra-install.log
rm -rf aastra-rpm > /dev/null 2>/dev/null
mkdir aastra-rpm > /dev/null 2>/dev/null
cd aastra-rpm

# $1 is the package name
# $2 is the version
# $3 is where to get it
# $4 is how to install it
# $5 is how to remove previous package
# $6 is the package file name to check
function package_install
{
echo -n "Checking package $1 $2 ... "
res1=`rpm -q $1 | grep -c "not installed"`
if [ -n "$2" ] 
then
	res2=`rpm -q $1 | grep -c $2`
else
	res2="1"
fi
if [ $res1 = "1" ]
then
	echo "Installation needed"
	if [ -n "$3" ]
	then
		echo -n "     Downloading package ... "
		`$3 >> /tmp/aastra-install.log 2>>/tmp/aastra-install.log`
		echo "OK"
	fi
	echo -n "     Installing package ... "
	`$4 >> /tmp/aastra-install.log 2>>/tmp/aastra-install.log`
	res1=`rpm -q $1 | grep -c "not installed"`
	if [ $res1 != "1" ]
	then
		echo "OK"
	else
		echo "FAILED"
		echo "Please check /tmp/aastra_install.log."
	fi
else
	if [ $res2 = "1" ]
	then
		echo "Nothing to do"
	else
		echo "Upgrade needed"
		echo -n "     Removing installed package ... "
		`$5 >>/tmp/aastra-install.log 2>>/tmp/aastra-install.log`
		echo "OK"
		if [ -n "$3" ]
		then
			if [ -n "$6" ] 
			then
				`rm -rf $5 >/dev/null 2>/dev/null`
			fi
			echo -n "     Downloading package ... "
			`$3 >>/tmp/aastra-install.log 2>>/tmp/aastra-install.log`
			if [ -n "$5" ] 
			then
				if [ -f "$6" ] 
				then
					echo "OK"
				else
					echo "FAILED"
					exit
				fi
			else
				echo "OK"
			fi
		fi
		echo -n "     Installing package ... "
		`$4 >>/tmp/aastra-install.log 2>>/tmp/aastra-install.log`
		res1=`rpm -q $1 | grep -c "not installed"`
		if [ $res1 != "1" ]
		then
			echo "OK"
		else
			echo "FAILED"
			echo "Please check /tmp/aastra_install.log."
		fi
	fi
fi
}

# $1 is the package name
# $2 is the version
# $3 is where to get it
# $4 is how to install it
# $5 is how to upgrade package
# $6 is the package file name to check
function firmware_install
{
echo -n "Checking phone firmware package ... "
res1=`rpm -q aastra-ipphone | grep -c "not installed"`
res2=`rpm -q aastra-ipphone | grep -c $2`
if [ $res1 = "1" ]
then
	echo "Installation needed"
	if [ -n "$3" ]
	then
		echo -n "     Downloading package ... "
		`$3 >> /tmp/aastra-install.log 2>>/tmp/aastra-install.log`
		if [ -n "$5" ] 
		then
			if [ -f "$6" ] 
			then
				echo "OK"
			else
				echo "FAILED"
				echo "Please check /tmp/aastra_install.log."
				exit
			fi
		else
			echo "Done"
		fi
	fi
	echo -n "     Installing package ... "
	`$4 >> /tmp/aastra-install.log 2>>/tmp/aastra-install.log`
	res2=`rpm -q aastra-ipphone | grep -c $2`
	if [ $res2 = "1" ]
	then
		echo "OK"
	else
		echo "FAILED"
		echo "Please check /tmp/aastra_install.log."
	fi
else
	if [ $res2 = "1" ]
	then
		echo "Nothing to do"
	else
		echo "Upgrade needed"
		if [ -n "$3" ]
		then
			if [ -n "$6" ] 
			then
				`rm -rf $5 >/dev/null 2>/dev/null`
			fi
			echo -n "     Downloading package ... "
			`$3 >>/tmp/aastra-install.log 2>>/tmp/aastra-install.log`
			if [ -n "$5" ] 
			then
				if [ -f "$6" ] 
				then
					echo "OK"
				else
					echo "FAILED"
					echo "Please check /tmp/aastra_install.log."
					exit
				fi
			else
				echo "OK"
			fi
		fi
		echo -n "     Upgrading package ... "
		`$5 >>/tmp/aastra-install.log 2>>/tmp/aastra-install.log`
		res2=`rpm -q aastra-ipphone | grep -c $2`
		if [ $res2 = "1" ]
		then
			echo "OK"
		else
			echo "FAILED"
			echo "Please check /tmp/aastra_install.log."
		fi
	fi
fi
}

#
# Special uninstall for mDNSResponder
#
function mDNSResponder_uninstall
{
echo -n "Checking mDNSResponder package ... "
res1=`rpm -q mDNSResponder-util | grep -c "not installed"`
if [ $res1 = "1" ]
then
	echo "Nothing to do"
else
	echo "Removal needed"
	echo -n "     Removing package ... "
	/etc/rd.d/init.d/mDNSResponder stop >/dev/null 2>/dev/null
	rpm -e mDNSResponder-108.5 mDNSResponder-util-108.5 >/dev/null 2>/dev/null
	echo "OK"
fi
}

#
# Body of the script
#

# Prepare the global variables
script_version=2.3.0
script_edition=1
phone_version=2.6.0
phone_edition=2
if [ "$1" = "debug" ]
then
	SOURCE="http://192.168.0.112/$script_version"
else
	if [ "$1" = "beta" ]
	then
		SOURCE="http://65.205.71.13/$script_version"
	else
		SOURCE="http://pbxinaflash.net/source/aastra-xml-$script_version"
	fi
fi

# Introduction
echo "Installation of Aastra XML scripts version $script_version $2 (32/64 bits)"
echo

# PHP-GD
package_install "php-gd" "" "" "yum -y install php-gd"

# PHP LDAP
package_install "php-ldap" "" "" "yum -y install php-ldap"

# AVAHI
package_install "avahi" "" "" "yum -y install avahi"

# PHONE FIRMWARE
firmware_install "aastra-ipphone" "$phone_version-$phone_edition" "wget $SOURCE/aastra-ipphone-$phone_version-$phone_edition.noarch.rpm" "rpm -i aastra-ipphone-$phone_version-$phone_edition.noarch.rpm" "rpm -U aastra-ipphone-$phone_version-$phone_edition.noarch.rpm" "aastra-ipphone-$phone_version-$phone_edition.noarch.rpm"

# XML SCRIPTS
if [ "$2" = "" ]
then
	package_install "aastra-xml-scripts" "$script_version" "wget $SOURCE/aastra-xml-scripts-$script_version-$script_edition.noarch.rpm" "rpm -i aastra-xml-scripts-$script_version-$script_edition.noarch.rpm" "rpm -e aastra-xml-scripts" "aastra-xml-scripts-$script_version-$script_edition.noarch.rpm"
else
	package_install "aastra-xml-scripts" "$script_version" "wget $SOURCE/aastra-xml-scripts-$script_version-1-$script_edition.noarch.rpm" "rpm -i aastra-xml-scripts-$script_version-$script_edition-$2.noarch.rpm" "rpm -e aastra-xml-scripts" "aastra-xml-scripts-$script_version-$script_edition-$2.noarch.rpm"
fi

# MDNSRESPONDER
mDNSResponder_uninstall

# MODIFY FIREWALL RULES FOR MDNS RESPONDER
echo -n "Modifying firewall rules for auto-discovery ... "
res=`grep 5353 /etc/sysconfig/iptables`
if [ "$res" = "-A INPUT -p udp -m udp --dport 5353 -j ACCEPT " ]
then
	echo "Nothing to do"
else
	iptables -A INPUT -p udp -m udp --dport 5353 -j ACCEPT >/dev/null 2>/dev/null
	iptables-save > /etc/sysconfig/iptables 2>/dev/null
	service iptables restart >/dev/null 2>/dev/null
	echo "OK"
fi

# Change read/write mode just to be sure + Cleanup
echo -n "Setting permissions ... "
chmod -R a+rwx /tftpboot
chown -R asterisk.asterisk /tftpboot
cd /tmp
rm -rf aastra-rpm > /dev/null 2>/dev/null
echo "OK"

# End of the scripts
echo
res=`rpm -q aastra-xml-scripts | grep -c $script_version`
if [ $res = "1" ]
then
	rm -rf /tmp/aastra-install.log >/dev/null 2>/dev/null
	echo "Aastra XML scripts $script_version successfully installed."
	echo "Please run setup-aastra-xml to generate aastra.cfg."
	echo "Please run /var/www/html/aastra/utilities/check_install to check installation."
else
	echo "Aastra XML scripts $script_version installation FAILED."
	echo "Please check /tmp/aastra_install.log."
fi
